/**
 *  Copyright (c) 2012 BMW
 *
 *  \author Christian Mueller, christian.ei.mueller@bmw.de BMW 2011,2012
 *
 *  \copyright
 *  Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction,
 *  including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so,
 *  subject to the following conditions:
 *  The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
 *  THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *  For further information see http://www.genivi.org/.
 */
/************************************************************************
 *FILE        :  CAmRoutingSenderAsync.h
 *SW-COMPONENT:  G3G Audio Component
 *DESCRIPTION  :  Implementation of GENIVI IAmRoutingSend Interface.
 *AUTHOR      :  RBEI/ECG1 - Bipin Krishnan
 *COPYRIGHT    :
 *HISTORY      :
 *06.09.2012  Rev 1.0    RBEI/ECG1 - Bipin Krishnan  Initial Revision
 *19.03.2013  Rev 2.0    RBEI/ECG4 - Pratheesh        Changes for Audio Manager -
                                                    vehicle domain
 *10.04.2013  Rev 3.0   RBEI/ECG4 - Pratheesh       Changed the source list and sink list handling
                                                    Changes done after testing with V850 simulator
 *24.04.2013  Rev 4.0   RBEI/ECG4 - Pratheesh       AM and Vehicle domain connection ID mapping is removed
************************************************************************/
#ifndef ROUTINGSENDER_H_
#define ROUTINGSENDER_H_

#include <memory.h>
#include <map>
#include <queue>
#include <vector>
#include <semaphore.h>
#include <sys/signalfd.h>
#include <signal.h>

#include "IAmRouting.h"
#include "IAmRoutingReceiverShadow.h"

#define BUS_NAME    "RoutingAsync1"
#define DOMAIN_NAME "AsyncDomain2"
#define NODE_NAME   "AsyncNode2"
#define SINK_NAME   "INTERNAL_AMP"
#define TUNER_FM_SRC "TUNER_FM"
#define TUNER_AM_SRC "TUNER_AM"
#define ONE_NANO_SEC  1000000000

namespace am
{

class CAmRoutingSenderAsync: public IAmRoutingSend
{
public:
    CAmRoutingSenderAsync();
    virtual ~CAmRoutingSenderAsync() throw();
    am_Error_e startupInterface(IAmRoutingReceive* routingreceiveinterface) ;
    void setRoutingReady(const uint16_t handle) ;
    void setRoutingRundown(const uint16_t handle) ;
    am_Error_e asyncAbort(const am_Handle_s handle) ;
    am_Error_e asyncConnect(const am_Handle_s handle, const am_connectionID_t connectionID, const am_sourceID_t sourceID, const am_sinkID_t sinkID, const am_CustomConnectionFormat_t connectionFormat) ;
    am_Error_e asyncDisconnect(const am_Handle_s handle, const am_connectionID_t connectionID) ;
    am_Error_e asyncSetSinkVolume(const am_Handle_s handle, const am_sinkID_t sinkID, const am_volume_t volume, const am_CustomRampType_t ramp, const am_time_t time) ;
    am_Error_e asyncSetSourceVolume(const am_Handle_s handle, const am_sourceID_t sourceID, const am_volume_t volume, const am_CustomRampType_t ramp, const am_time_t time) ;
    am_Error_e asyncSetSourceState(const am_Handle_s handle, const am_sourceID_t sourceID, const am_SourceState_e state) ;
    am_Error_e asyncSetSinkSoundProperties(const am_Handle_s handle, const am_sinkID_t sinkID, const std::vector<am_SoundProperty_s>& listSoundProperties) ;
    am_Error_e asyncSetSinkSoundProperty(const am_Handle_s handle, const am_sinkID_t sinkID, const am_SoundProperty_s& soundProperty) ;
    am_Error_e asyncSetSourceSoundProperties(const am_Handle_s handle, const am_sourceID_t sourceID, const std::vector<am_SoundProperty_s>& listSoundProperties) ;
    am_Error_e asyncSetSourceSoundProperty(const am_Handle_s handle, const am_sourceID_t sourceID, const am_SoundProperty_s& soundProperty) ;
    am_Error_e asyncCrossFade(const am_Handle_s handle, const am_crossfaderID_t crossfaderID, const am_HotSink_e hotSink, const am_CustomRampType_t rampType, const am_time_t time) ;
    am_Error_e setDomainState(const am_domainID_t domainID, const am_DomainState_e domainState) ;
    am_Error_e returnBusName(std::string& BusName) const ;
    void getInterfaceVersion(std::string& version) const ;
  /*********************************audiomanager 2.0 version**********************************************/
  am_Error_e asyncSetVolumes(const am_Handle_s handle, const std::vector<am_Volumes_s>& listVolumes) ;
    am_Error_e asyncSetSinkNotificationConfiguration(const am_Handle_s handle, const am_sinkID_t sinkID, const am_NotificationConfiguration_s& notificationConfiguration) ;
    am_Error_e asyncSetSourceNotificationConfiguration(const am_Handle_s handle, const am_sourceID_t sourceID, const am_NotificationConfiguration_s& notificationConfiguration) ;
  /*********************************audiomanager 2.0 version**********************************************/

private:
    am_Error_e enRegisterDomain();

    am_domainID_t g_domainId;
    CAmSocketHandler* m_pSocketHandler;
    IAmRoutingReceive* mReceiveInterface;
    IAmRoutingReceiverShadow* mReceiverShadowInterface;

    std::map<am_connectionID_t, am::am_sourceID_t> m_aConnMap;

};

}

#endif /* ROUTINGSENDER_H_ */
